#include "skse64/NiRTTI.h"
#include "skse64/NiObjects.h"

NiObject * DoNiRTTICast(NiObject * src, const NiRTTI * typeInfo)
{
	uintptr_t typeAddr = uintptr_t(typeInfo) + RelocationManager::s_baseAddr;
	if (src)
		for (NiRTTI * iter = src->GetRTTI(); iter; iter = iter->parent)
			if (iter == (NiRTTI *)typeAddr)
				return src;

	return nullptr;
}

bool IsType(NiRTTI * rtti, const NiRTTI * typeInfo)
{
	uintptr_t typeAddr = uintptr_t(typeInfo) + RelocationManager::s_baseAddr;
	if (rtti)
		return uintptr_t(rtti) == typeAddr;

	return false;
}

const NiRTTI *	NiRTTI_BGSDecalNode = (NiRTTI *)0x01F891A0;
const NiRTTI *	NiRTTI_BSAnimGroupSequence = (NiRTTI *)0x01F89358;
const NiRTTI *	NiRTTI_BSSplatterExtraData = (NiRTTI *)0x02F8A3D0;
const NiRTTI *	NiRTTI_BGSAddonNodeSoundHandleExtra = (NiRTTI *)0x02F8A838;
const NiRTTI *	NiRTTI_REFRSyncController = (NiRTTI *)0x02FC48B0;
const NiRTTI *	NiRTTI_bhkCartTether = (NiRTTI *)0x02FC6008;
const NiRTTI *	NiRTTI_bhkTiltPreventAction = (NiRTTI *)0x02FC6018;
const NiRTTI *	NiRTTI_bhkWheelAction = (NiRTTI *)0x02FC6028;
const NiRTTI *	NiRTTI_BSFaceGenAnimationData = (NiRTTI *)0x02FC6670;
const NiRTTI *	NiRTTI_BSFaceGenModelExtraData = (NiRTTI *)0x02FCCB90;
const NiRTTI *	NiRTTI_BSFaceGenBaseMorphExtraData = (NiRTTI *)0x02FCCBB8;
const NiRTTI *	NiRTTI_BSFaceGenMorphData = (NiRTTI *)0x02FCCBC8;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHead = (NiRTTI *)0x02FCCBD8;
const NiRTTI *	NiRTTI_BSFaceGenMorphDataHair = (NiRTTI *)0x02FCCBE8;
const NiRTTI *	NiRTTI_BSFaceGenNiNode = (NiRTTI *)0x02FCCC28;
const NiRTTI *	NiRTTI_BSTempEffect = (NiRTTI *)0x02FD2318;
const NiRTTI *	NiRTTI_BSTempEffectDebris = (NiRTTI *)0x02FD2398;
const NiRTTI *	NiRTTI_BSTempEffectGeometryDecal = (NiRTTI *)0x02FD23B8;
const NiRTTI *	NiRTTI_BSTempEffectParticle = (NiRTTI *)0x02FD2468;
const NiRTTI *	NiRTTI_BSTempEffectSimpleDecal = (NiRTTI *)0x02FD2490;
const NiRTTI *	NiRTTI_BSTempEffectSPG = (NiRTTI *)0x02FD24A8;
const NiRTTI *	NiRTTI_bhkAutoWater = (NiRTTI *)0x02FE9890;
const NiRTTI *	NiRTTI_ModelReferenceEffect = (NiRTTI *)0x02FEAC88;
const NiRTTI *	NiRTTI_ReferenceEffect = (NiRTTI *)0x02FEACC8;
const NiRTTI *	NiRTTI_ShaderReferenceEffect = (NiRTTI *)0x02FEACF8;
const NiRTTI *	NiRTTI_SummonPlacementEffect = (NiRTTI *)0x02FEAD28;
const NiRTTI *	NiRTTI_SceneGraph = (NiRTTI *)0x02FFD750;
const NiRTTI *	NiRTTI_BSDoorHavokController = (NiRTTI *)0x02FFF478;
const NiRTTI *	NiRTTI_BSPlayerDistanceCheckController = (NiRTTI *)0x02FFF488;
const NiRTTI *	NiRTTI_BSSimpleScaleController = (NiRTTI *)0x02FFF498;
const NiRTTI *	NiRTTI_NiObject = (NiRTTI *)0x0316AB08;
const NiRTTI *	NiRTTI_NiAVObject = (NiRTTI *)0x0316AB40;
const NiRTTI *	NiRTTI_NiNode = (NiRTTI *)0x0316AB78;
const NiRTTI *	NiRTTI_NiObjectNET = (NiRTTI *)0x0316AD08;
const NiRTTI *	NiRTTI_NiLight = (NiRTTI *)0x0316AD68;
const NiRTTI *	NiRTTI_NiSwitchNode = (NiRTTI *)0x0316AD78;
const NiRTTI *	NiRTTI_NiStringsExtraData = (NiRTTI *)0x0316AD88;
const NiRTTI *	NiRTTI_NiCamera = (NiRTTI *)0x0316AD98;
const NiRTTI *	NiRTTI_BSTriShape = (NiRTTI *)0x0316ADB0;
const NiRTTI *	NiRTTI_NiProperty = (NiRTTI *)0x0316ADC0;
const NiRTTI *	NiRTTI_NiAlphaProperty = (NiRTTI *)0x0316ADD8;
const NiRTTI *	NiRTTI_NiSourceTexture = (NiRTTI *)0x0316BE08;
const NiRTTI *	NiRTTI_BSFlattenedBoneTree = (NiRTTI *)0x0316BE18;
const NiRTTI *	NiRTTI_BSDismemberSkinInstance = (NiRTTI *)0x0316BE60;
const NiRTTI *	NiRTTI_NiStringExtraData = (NiRTTI *)0x0316BE70;
const NiRTTI *	NiRTTI_NiTimeController = (NiRTTI *)0x0316BE80;
const NiRTTI *	NiRTTI_NiExtraData = (NiRTTI *)0x0316BEA0;
const NiRTTI *	NiRTTI_NiGeometryData = (NiRTTI *)0x0316BEB0;
const NiRTTI *	NiRTTI_BSGeometry = (NiRTTI *)0x0316BEC8;
const NiRTTI *	NiRTTI_BSDynamicTriShape = (NiRTTI *)0x0316BEE0;
const NiRTTI *	NiRTTI_NiPointLight = (NiRTTI *)0x0316BEF0;
const NiRTTI *	NiRTTI_NiDefaultAVObjectPalette = (NiRTTI *)0x0316BF00;
const NiRTTI *	NiRTTI_NiBillboardNode = (NiRTTI *)0x0316BF28;
const NiRTTI *	NiRTTI_NiDirectionalLight = (NiRTTI *)0x0316BF38;
const NiRTTI *	NiRTTI_NiCullingProcess = (NiRTTI *)0x0316BF48;
const NiRTTI *	NiRTTI_NiParticles = (NiRTTI *)0x0316BF60;
const NiRTTI *	NiRTTI_NiTexture = (NiRTTI *)0x0316BFA0;
const NiRTTI *	NiRTTI_NiSkinPartition = (NiRTTI *)0x0316C0B0;
const NiRTTI *	NiRTTI_NiVertWeightsExtraData = (NiRTTI *)0x0316C0C0;
const NiRTTI *	NiRTTI_NiSkinInstance = (NiRTTI *)0x0316C0D0;
const NiRTTI *	NiRTTI_NiAVObjectPalette = (NiRTTI *)0x0316C0E0;
const NiRTTI *	NiRTTI_NiGeometry = (NiRTTI *)0x0316C0F0;
const NiRTTI *	NiRTTI_NiSkinData = (NiRTTI *)0x0316C120;
const NiRTTI *	NiRTTI_NiShadeProperty = (NiRTTI *)0x0316C130;
const NiRTTI *	NiRTTI_NiAlphaAccumulator = (NiRTTI *)0x0316C148;
const NiRTTI *	NiRTTI_NiAmbientLight = (NiRTTI *)0x0316C158;
const NiRTTI *	NiRTTI_NiBinaryExtraData = (NiRTTI *)0x0316C168;
const NiRTTI *	NiRTTI_NiBooleanExtraData = (NiRTTI *)0x0316C178;
const NiRTTI *	NiRTTI_NiBSPNode = (NiRTTI *)0x0316C188;
const NiRTTI *	NiRTTI_NiColorExtraData = (NiRTTI *)0x0316C198;
const NiRTTI *	NiRTTI_NiFloatExtraData = (NiRTTI *)0x0316C1A8;
const NiRTTI *	NiRTTI_NiFloatsExtraData = (NiRTTI *)0x0316C1B8;
const NiRTTI *	NiRTTI_NiFogProperty = (NiRTTI *)0x0316C1C8;
const NiRTTI *	NiRTTI_NiIntegerExtraData = (NiRTTI *)0x0316C1E0;
const NiRTTI *	NiRTTI_NiIntegersExtraData = (NiRTTI *)0x0316C1F0;
const NiRTTI *	NiRTTI_NiParticlesData = (NiRTTI *)0x0316C238;
const NiRTTI *	NiRTTI_NiParticleMeshesData = (NiRTTI *)0x0316C248;
const NiRTTI *	NiRTTI_NiParticleMeshes = (NiRTTI *)0x0316C258;
const NiRTTI *	NiRTTI_NiSpotLight = (NiRTTI *)0x0316C268;
const NiRTTI *	NiRTTI_NiSwitchStringExtraData = (NiRTTI *)0x0316C278;
const NiRTTI *	NiRTTI_NiTriShapeData = (NiRTTI *)0x0316C288;
const NiRTTI *	NiRTTI_NiTriShape = (NiRTTI *)0x0316C298;
const NiRTTI *	NiRTTI_NiTriStripsData = (NiRTTI *)0x0316C2A8;
const NiRTTI *	NiRTTI_NiTriStrips = (NiRTTI *)0x0316C2B8;
const NiRTTI *	NiRTTI_NiVectorExtraData = (NiRTTI *)0x0316C2C8;
const NiRTTI *	NiRTTI_BSLODTriShape = (NiRTTI *)0x0316C2F0;
const NiRTTI *	NiRTTI_NiAdditionalGeometryData = (NiRTTI *)0x0316C300;
const NiRTTI *	NiRTTI_BSSegmentedTriShape = (NiRTTI *)0x0316C318;
const NiRTTI *	NiRTTI_NiAccumulator = (NiRTTI *)0x0316C350;
const NiRTTI *	NiRTTI_NiBackToFrontAccumulator = (NiRTTI *)0x0316C360;
const NiRTTI *	NiRTTI_NiTriBasedGeomData = (NiRTTI *)0x0316C370;
const NiRTTI *	NiRTTI_NiTriBasedGeom = (NiRTTI *)0x0316C380;
const NiRTTI *	NiRTTI_NiCollisionData = (NiRTTI *)0x0316C3C8;
const NiRTTI *	NiRTTI_NiControllerManager = (NiRTTI *)0x0316C458;
const NiRTTI *	NiRTTI_NiControllerSequence = (NiRTTI *)0x0316C478;
const NiRTTI *	NiRTTI_NiBlendInterpolator = (NiRTTI *)0x0316C4A8;
const NiRTTI *	NiRTTI_NiMultiTargetTransformController = (NiRTTI *)0x0316C4B8;
const NiRTTI *	NiRTTI_BSMultiTargetTreadTransfController = (NiRTTI *)0x0316C4C8;
const NiRTTI *	NiRTTI_NiInterpController = (NiRTTI *)0x0316C4D8;
const NiRTTI *	NiRTTI_NiFloatData = (NiRTTI *)0x0316D2A8;
const NiRTTI *	NiRTTI_NiFloatInterpolator = (NiRTTI *)0x0316D2B8;
const NiRTTI *	NiRTTI_NiColorData = (NiRTTI *)0x0316D2C8;
const NiRTTI *	NiRTTI_NiColorInterpolator = (NiRTTI *)0x0316D2D8;
const NiRTTI *	NiRTTI_NiSingleInterpController = (NiRTTI *)0x0316D2E8;
const NiRTTI *	NiRTTI_NiTransformInterpolator = (NiRTTI *)0x0316D2F8;
const NiRTTI *	NiRTTI_NiPathInterpolator = (NiRTTI *)0x0316D308;
const NiRTTI *	NiRTTI_NiBlendTransformInterpolator = (NiRTTI *)0x0316D328;
const NiRTTI *	NiRTTI_NiBlendFloatInterpolator = (NiRTTI *)0x0316D338;
const NiRTTI *	NiRTTI_NiFloatExtraDataController = (NiRTTI *)0x0316D348;
const NiRTTI *	NiRTTI_NiTransformController = (NiRTTI *)0x0316D358;
const NiRTTI *	NiRTTI_NiBlendAccumTransformInterpolator = (NiRTTI *)0x0316D370;
const NiRTTI *	NiRTTI_NiInterpolator = (NiRTTI *)0x0316D380;
const NiRTTI *	NiRTTI_BSBlendTreadTransfInterpolator = (NiRTTI *)0x0316D3A0;
const NiRTTI *	NiRTTI_NiKeyBasedInterpolator = (NiRTTI *)0x0316D3B8;
const NiRTTI *	NiRTTI_NiTransformData = (NiRTTI *)0x0316D438;
const NiRTTI *	NiRTTI_NiPosData = (NiRTTI *)0x0316D448;
const NiRTTI *	NiRTTI_NiBlendBoolInterpolator = (NiRTTI *)0x0316D458;
const NiRTTI *	NiRTTI_NiBlendColorInterpolator = (NiRTTI *)0x0316D468;
const NiRTTI *	NiRTTI_NiBlendPoint3Interpolator = (NiRTTI *)0x0316D478;
const NiRTTI *	NiRTTI_NiBlendQuaternionInterpolator = (NiRTTI *)0x0316D488;
const NiRTTI *	NiRTTI_NiBoolData = (NiRTTI *)0x0316D498;
const NiRTTI *	NiRTTI_NiBoolInterpolator = (NiRTTI *)0x0316D4A8;
const NiRTTI *	NiRTTI_NiBoolTimelineInterpolator = (NiRTTI *)0x0316D4B8;
const NiRTTI *	NiRTTI_NiBSplineBasisData = (NiRTTI *)0x0316D4C8;
const NiRTTI *	NiRTTI_NiBSplineData = (NiRTTI *)0x0316D4D8;
const NiRTTI *	NiRTTI_NiBSplineColorInterpolator = (NiRTTI *)0x0316D4E8;
const NiRTTI *	NiRTTI_NiBSplineCompColorInterpolator = (NiRTTI *)0x0316D4F8;
const NiRTTI *	NiRTTI_NiBSplineCompFloatInterpolator = (NiRTTI *)0x0316D508;
const NiRTTI *	NiRTTI_NiBSplineCompPoint3Interpolator = (NiRTTI *)0x0316D518;
const NiRTTI *	NiRTTI_NiBSplineCompTransformInterpolator = (NiRTTI *)0x0316D528;
const NiRTTI *	NiRTTI_NiBSplineFloatInterpolator = (NiRTTI *)0x0316D538;
const NiRTTI *	NiRTTI_NiBSplinePoint3Interpolator = (NiRTTI *)0x0316D548;
const NiRTTI *	NiRTTI_NiBSplineTransformInterpolator = (NiRTTI *)0x0316D558;
const NiRTTI *	NiRTTI_NiColorExtraDataController = (NiRTTI *)0x0316D568;
const NiRTTI *	NiRTTI_NiFloatsExtraDataController = (NiRTTI *)0x0316D578;
const NiRTTI *	NiRTTI_NiFloatsExtraDataPoint3Controller = (NiRTTI *)0x0316D588;
const NiRTTI *	NiRTTI_NiKeyframeManager = (NiRTTI *)0x0316D5A0;
const NiRTTI *	NiRTTI_NiLightColorController = (NiRTTI *)0x0316D5B0;
const NiRTTI *	NiRTTI_NiLightDimmerController = (NiRTTI *)0x0316D5C0;
const NiRTTI *	NiRTTI_NiLookAtController = (NiRTTI *)0x0316D5D0;
const NiRTTI *	NiRTTI_NiLookAtInterpolator = (NiRTTI *)0x0316D5E0;
const NiRTTI *	NiRTTI_NiMorphData = (NiRTTI *)0x0316D5F0;
const NiRTTI *	NiRTTI_NiPathController = (NiRTTI *)0x0316D600;
const NiRTTI *	NiRTTI_NiPoint3Interpolator = (NiRTTI *)0x0316D610;
const NiRTTI *	NiRTTI_NiQuaternionInterpolator = (NiRTTI *)0x0316D620;
const NiRTTI *	NiRTTI_NiRollController = (NiRTTI *)0x0316D630;
const NiRTTI *	NiRTTI_NiRotData = (NiRTTI *)0x0316D640;
const NiRTTI *	NiRTTI_NiSequence = (NiRTTI *)0x0316D650;
const NiRTTI *	NiRTTI_NiSequenceStreamHelper = (NiRTTI *)0x0316D670;
const NiRTTI *	NiRTTI_NiStringPalette = (NiRTTI *)0x0316D680;
const NiRTTI *	NiRTTI_NiTextKeyExtraData = (NiRTTI *)0x0316D690;
const NiRTTI *	NiRTTI_NiUVData = (NiRTTI *)0x0316D6A0;
const NiRTTI *	NiRTTI_NiVisController = (NiRTTI *)0x0316D6B0;
const NiRTTI *	NiRTTI_BSAnimNote = (NiRTTI *)0x0316D6C0;
const NiRTTI *	NiRTTI_BSAnimNotes = (NiRTTI *)0x0316D6D0;
const NiRTTI *	NiRTTI_BSGrabIKNote = (NiRTTI *)0x0316D6E0;
const NiRTTI *	NiRTTI_BSLookIKNote = (NiRTTI *)0x0316D6F0;
const NiRTTI *	NiRTTI_BSRotAccumTransfInterpolator = (NiRTTI *)0x0316D700;
const NiRTTI *	NiRTTI_BSTreadTransfInterpolator = (NiRTTI *)0x0316D710;
const NiRTTI *	NiRTTI_BSFrustumFOVController = (NiRTTI *)0x0316D720;
const NiRTTI *	NiRTTI_NiExtraDataController = (NiRTTI *)0x0316D7B8;
const NiRTTI *	NiRTTI_NiBSplineInterpolator = (NiRTTI *)0x0316D7C8;
const NiRTTI *	NiRTTI_NiPoint3InterpController = (NiRTTI *)0x0316D7D8;
const NiRTTI *	NiRTTI_NiFloatInterpController = (NiRTTI *)0x0316D7E8;
const NiRTTI *	NiRTTI_NiFloatController = (NiRTTI *)0x0316D7F8;
const NiRTTI *	NiRTTI_NiBoolInterpController = (NiRTTI *)0x0316D808;
const NiRTTI *	NiRTTI_NiParticleSystem = (NiRTTI *)0x0316D820;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlr = (NiRTTI *)0x0316D830;
const NiRTTI *	NiRTTI_NiPSysGravityModifier = (NiRTTI *)0x0316D840;
const NiRTTI *	NiRTTI_BSPSysHavokUpdateModifier = (NiRTTI *)0x0316D850;
const NiRTTI *	NiRTTI_NiMeshParticleSystem = (NiRTTI *)0x0316D868;
const NiRTTI *	NiRTTI_NiPSysCylinderEmitter = (NiRTTI *)0x0316D880;
const NiRTTI *	NiRTTI_BSStripParticleSystem = (NiRTTI *)0x0316D890;
const NiRTTI *	NiRTTI_NiPSysEmitter = (NiRTTI *)0x0316D8A0;
const NiRTTI *	NiRTTI_NiPSysModifierCtlr = (NiRTTI *)0x0316D8B8;
const NiRTTI *	NiRTTI_NiPSysModifier = (NiRTTI *)0x0316D8C8;
const NiRTTI *	NiRTTI_NiPSysMeshUpdateModifier = (NiRTTI *)0x0316D8D8;
const NiRTTI *	NiRTTI_NiPSysUpdateCtlr = (NiRTTI *)0x0316D8E8;
const NiRTTI *	NiRTTI_NiMeshPSysData = (NiRTTI *)0x0316D8F8;
const NiRTTI *	NiRTTI_NiPSysAirFieldAirFrictionCtlr = (NiRTTI *)0x0316D908;
const NiRTTI *	NiRTTI_NiPSysAirFieldInheritVelocityCtlr = (NiRTTI *)0x0316D918;
const NiRTTI *	NiRTTI_NiPSysAirFieldModifier = (NiRTTI *)0x0316D928;
const NiRTTI *	NiRTTI_NiPSysAirFieldSpreadCtlr = (NiRTTI *)0x0316D938;
const NiRTTI *	NiRTTI_NiPSysAgeDeathModifier = (NiRTTI *)0x0316D948;
const NiRTTI *	NiRTTI_NiPSysBombModifier = (NiRTTI *)0x0316D958;
const NiRTTI *	NiRTTI_NiPSysBoundUpdateModifier = (NiRTTI *)0x0316D968;
const NiRTTI *	NiRTTI_NiPSysBoxEmitter = (NiRTTI *)0x0316D978;
const NiRTTI *	NiRTTI_NiPSysColliderManager = (NiRTTI *)0x0316D988;
const NiRTTI *	NiRTTI_NiPSysColorModifier = (NiRTTI *)0x0316D998;
const NiRTTI *	NiRTTI_NiPSysData = (NiRTTI *)0x0316D9A8;
const NiRTTI *	NiRTTI_NiPSysDragFieldModifier = (NiRTTI *)0x0316D9B8;
const NiRTTI *	NiRTTI_NiPSysDragModifier = (NiRTTI *)0x0316D9C8;
const NiRTTI *	NiRTTI_NiPSysEmitterCtlrData = (NiRTTI *)0x0316D9D8;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationCtlr = (NiRTTI *)0x0316D9E8;
const NiRTTI *	NiRTTI_NiPSysEmitterDeclinationVarCtlr = (NiRTTI *)0x0316D9F8;
const NiRTTI *	NiRTTI_NiPSysEmitterInitialRadiusCtlr = (NiRTTI *)0x0316DA08;
const NiRTTI *	NiRTTI_NiPSysEmitterLifeSpanCtlr = (NiRTTI *)0x0316DA18;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleCtlr = (NiRTTI *)0x0316DA28;
const NiRTTI *	NiRTTI_NiPSysEmitterPlanarAngleVarCtlr = (NiRTTI *)0x0316DA38;
const NiRTTI *	NiRTTI_NiPSysEmitterSpeedCtlr = (NiRTTI *)0x0316DA48;
const NiRTTI *	NiRTTI_NiPSysFieldAttenuationCtlr = (NiRTTI *)0x0316DA58;
const NiRTTI *	NiRTTI_NiPSysFieldMagnitudeCtlr = (NiRTTI *)0x0316DA68;
const NiRTTI *	NiRTTI_NiPSysFieldMaxDistanceCtlr = (NiRTTI *)0x0316DA78;
const NiRTTI *	NiRTTI_NiPSysGravityFieldModifier = (NiRTTI *)0x0316DA88;
const NiRTTI *	NiRTTI_NiPSysGravityStrengthCtlr = (NiRTTI *)0x0316DA98;
const NiRTTI *	NiRTTI_NiPSysGrowFadeModifier = (NiRTTI *)0x0316DAA8;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleCtlr = (NiRTTI *)0x0316DAB8;
const NiRTTI *	NiRTTI_NiPSysInitialRotAngleVarCtlr = (NiRTTI *)0x0316DAC8;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedCtlr = (NiRTTI *)0x0316DAD8;
const NiRTTI *	NiRTTI_NiPSysInitialRotSpeedVarCtlr = (NiRTTI *)0x0316DAE8;
const NiRTTI *	NiRTTI_NiPSysMeshEmitter = (NiRTTI *)0x0316DAF8;
const NiRTTI *	NiRTTI_NiPSysModifierActiveCtlr = (NiRTTI *)0x0316DB28;
const NiRTTI *	NiRTTI_NiPSysPlanarCollider = (NiRTTI *)0x0316DB38;
const NiRTTI *	NiRTTI_NiPSysPositionModifier = (NiRTTI *)0x0316DB50;
const NiRTTI *	NiRTTI_NiPSysRadialFieldModifier = (NiRTTI *)0x0316DB60;
const NiRTTI *	NiRTTI_NiPSysResetOnLoopCtlr = (NiRTTI *)0x0316DB70;
const NiRTTI *	NiRTTI_NiPSysRotationModifier = (NiRTTI *)0x0316DB80;
const NiRTTI *	NiRTTI_NiPSysSpawnModifier = (NiRTTI *)0x0316DB90;
const NiRTTI *	NiRTTI_NiPSysSphereEmitter = (NiRTTI *)0x0316DBA0;
const NiRTTI *	NiRTTI_NiPSysSphericalCollider = (NiRTTI *)0x0316DBB0;
const NiRTTI *	NiRTTI_NiPSysTurbulenceFieldModifier = (NiRTTI *)0x0316DBC0;
const NiRTTI *	NiRTTI_NiPSysVortexFieldModifier = (NiRTTI *)0x0316DBD0;
const NiRTTI *	NiRTTI_BSStripPSysData = (NiRTTI *)0x0316DBE0;
const NiRTTI *	NiRTTI_BSPSysRecycleBoundModifier = (NiRTTI *)0x0316DBF8;
const NiRTTI *	NiRTTI_BSPSysInheritVelocityModifier = (NiRTTI *)0x0316DC08;
const NiRTTI *	NiRTTI_NiPSysVolumeEmitter = (NiRTTI *)0x0316DC18;
const NiRTTI *	NiRTTI_NiPSysModifierFloatCtlr = (NiRTTI *)0x0316DC28;
const NiRTTI *	NiRTTI_NiPSysFieldModifier = (NiRTTI *)0x0316DC38;
const NiRTTI *	NiRTTI_NiPSysModifierBoolCtlr = (NiRTTI *)0x0316DC48;
const NiRTTI *	NiRTTI_NiPSysCollider = (NiRTTI *)0x0316DC58;
const NiRTTI *	NiRTTI_BSMultiBound = (NiRTTI *)0x03175F88;
const NiRTTI *	NiRTTI_BSMultiBoundRoom = (NiRTTI *)0x03175F98;
const NiRTTI *	NiRTTI_BSMultiBoundAABB = (NiRTTI *)0x03175FB0;
const NiRTTI *	NiRTTI_BSMultiBoundOBB = (NiRTTI *)0x03175FC8;
const NiRTTI *	NiRTTI_BSXFlags = (NiRTTI *)0x03175FE8;
const NiRTTI *	NiRTTI_BSValueNode = (NiRTTI *)0x03176000;
const NiRTTI *	NiRTTI_BSWindModifier = (NiRTTI *)0x0317C580;
const NiRTTI *	NiRTTI_BSTempNodeManager = (NiRTTI *)0x0317C5A0;
const NiRTTI *	NiRTTI_BSTempNode = (NiRTTI *)0x0317C5B0;
const NiRTTI *	NiRTTI_BSOcclusionShape = (NiRTTI *)0x0317C5D0;
const NiRTTI *	NiRTTI_BSRangeNode = (NiRTTI *)0x0317C6C8;
const NiRTTI *	NiRTTI_BSBlastNode = (NiRTTI *)0x0317C900;
const NiRTTI *	NiRTTI_BSDebrisNode = (NiRTTI *)0x0317C910;
const NiRTTI *	NiRTTI_BSDamageStage = (NiRTTI *)0x0317C920;
const NiRTTI *	NiRTTI_BSPSysArrayEmitter = (NiRTTI *)0x0317C930;
const NiRTTI *	NiRTTI_PArrayPoint = (NiRTTI *)0x0317C940;
const NiRTTI *	NiRTTI_BSMultiStreamInstanceTriShape = (NiRTTI *)0x0317C968;
const NiRTTI *	NiRTTI_BSMultiBoundShape = (NiRTTI *)0x0317C998;
const NiRTTI *	NiRTTI_BSMultiBoundSphere = (NiRTTI *)0x0317C9A8;
const NiRTTI *	NiRTTI_BSOcclusionBox = (NiRTTI *)0x0317C9C0;
const NiRTTI *	NiRTTI_BSOcclusionPlane = (NiRTTI *)0x0317C9D8;
const NiRTTI *	NiRTTI_BSPortal = (NiRTTI *)0x0317C9E8;
const NiRTTI *	NiRTTI_BSPortalSharedNode = (NiRTTI *)0x0317C9F8;
const NiRTTI *	NiRTTI_BSBodyMorphOffsetsExtraData = (NiRTTI *)0x0317CA10;
const NiRTTI *	NiRTTI_BSBehaviorGraphExtraData = (NiRTTI *)0x0317CA20;
const NiRTTI *	NiRTTI_NiBSBoneLODController = (NiRTTI *)0x0317CA38;
const NiRTTI *	NiRTTI_BSCullingProcess = (NiRTTI *)0x0317CA58;
const NiRTTI *	NiRTTI_BSParticleSystemManager = (NiRTTI *)0x0317CA78;
const NiRTTI *	NiRTTI_BSFurnitureMarkerNode = (NiRTTI *)0x0317CAA0;
const NiRTTI *	NiRTTI_BSBound = (NiRTTI *)0x0317CB20;
const NiRTTI *	NiRTTI_BSMultiBoundNode = (NiRTTI *)0x0317CBB0;
const NiRTTI *	NiRTTI_BSBoneMap = (NiRTTI *)0x0317CBC0;
const NiRTTI *	NiRTTI_BSAnimInteractionMarker = (NiRTTI *)0x0317CBD8;
const NiRTTI *	NiRTTI_BSSceneGraph = (NiRTTI *)0x0317CBF0;
const NiRTTI *	NiRTTI_BSPSysMultiTargetEmitterCtlr = (NiRTTI *)0x0317CC08;
const NiRTTI *	NiRTTI_BSGeometryListCullingProcess = (NiRTTI *)0x0317CC20;
const NiRTTI *	NiRTTI_BSSubIndexTriShape = (NiRTTI *)0x0317CC38;
const NiRTTI *	NiRTTI_BSDistantObjectLargeRefExtraData = (NiRTTI *)0x0317CC48;
const NiRTTI *	NiRTTI_BSMasterParticleSystem = (NiRTTI *)0x0317E618;
const NiRTTI *	NiRTTI_BSProceduralLightningController = (NiRTTI *)0x0317E640;
const NiRTTI *	NiRTTI_BSInvMarker = (NiRTTI *)0x0317E650;
const NiRTTI *	NiRTTI_BSBoneLODExtraData = (NiRTTI *)0x0317E668;
const NiRTTI *	NiRTTI_BSReference = (NiRTTI *)0x0317E688;
const NiRTTI *	NiRTTI_BSNodeReferences = (NiRTTI *)0x0317E698;
const NiRTTI *	NiRTTI_BSDecalPlacementVectorExtraData = (NiRTTI *)0x0317E6A8;
const NiRTTI *	NiRTTI_BSParentVelocityModifier = (NiRTTI *)0x0317E6B8;
const NiRTTI *	NiRTTI_BSWArray = (NiRTTI *)0x0317E6C8;
const NiRTTI *	NiRTTI_BSMultiBoundCapsule = (NiRTTI *)0x0317E6E0;
const NiRTTI *	NiRTTI_BSPSysStripUpdateModifier = (NiRTTI *)0x0317E6F0;
const NiRTTI *	NiRTTI_BSPSysSubTexModifier = (NiRTTI *)0x0317E700;
const NiRTTI *	NiRTTI_BSPSysScaleModifier = (NiRTTI *)0x0317E710;
const NiRTTI *	NiRTTI_BSLagBoneController = (NiRTTI *)0x0317E720;
const NiRTTI *	NiRTTI_BSNonUniformScaleExtraData = (NiRTTI *)0x0317E730;
const NiRTTI *	NiRTTI_BSMeshLODTriShape = (NiRTTI *)0x0317E750;
const NiRTTI *	NiRTTI_BSNiNode = (NiRTTI *)0x0317E760;
const NiRTTI *	NiRTTI_BSInstanceTriShape = (NiRTTI *)0x0317E770;
const NiRTTI *	NiRTTI_bhkWorldObject = (NiRTTI *)0x03186DD8;
const NiRTTI *	NiRTTI_bhkWorld = (NiRTTI *)0x03186E18;
const NiRTTI *	NiRTTI_bhkRigidBody = (NiRTTI *)0x03187F58;
const NiRTTI *	NiRTTI_bhkCollisionObject = (NiRTTI *)0x03187F70;
const NiRTTI *	NiRTTI_bhkNiCollisionObject = (NiRTTI *)0x03188010;
const NiRTTI *	NiRTTI_bhkAttachmentCollisionObject = (NiRTTI *)0x031880A0;
const NiRTTI *	NiRTTI_WeaponObject = (NiRTTI *)0x031880B0;
const NiRTTI *	NiRTTI_bhkWorldM = (NiRTTI *)0x031880D0;
const NiRTTI *	NiRTTI_bhkRefObject = (NiRTTI *)0x031880F8;
const NiRTTI *	NiRTTI_bhkSerializable = (NiRTTI *)0x03188108;
const NiRTTI *	NiRTTI_bhkShape = (NiRTTI *)0x03188138;
const NiRTTI *	NiRTTI_bhkEntity = (NiRTTI *)0x03188150;
const NiRTTI *	NiRTTI_bhkPhantom = (NiRTTI *)0x03188168;
const NiRTTI *	NiRTTI_bhkAabbPhantom = (NiRTTI *)0x03188180;
const NiRTTI *	NiRTTI_bhkSphereRepShape = (NiRTTI *)0x03188198;
const NiRTTI *	NiRTTI_bhkConvexShape = (NiRTTI *)0x031881B0;
const NiRTTI *	NiRTTI_bhkPCollisionObject = (NiRTTI *)0x031881C0;
const NiRTTI *	NiRTTI_hkPackedNiTriStripsData = (NiRTTI *)0x031881D0;
const NiRTTI *	NiRTTI_bhkShapePhantom = (NiRTTI *)0x031881E8;
const NiRTTI *	NiRTTI_bhkSimpleShapePhantom = (NiRTTI *)0x03188200;
const NiRTTI *	NiRTTI_bhkCapsuleShape = (NiRTTI *)0x03188218;
const NiRTTI *	NiRTTI_bhkBoxShape = (NiRTTI *)0x03188230;
const NiRTTI *	NiRTTI_bhkSphereShape = (NiRTTI *)0x03188248;
const NiRTTI *	NiRTTI_bhkBvTreeShape = (NiRTTI *)0x03188260;
const NiRTTI *	NiRTTI_bhkNiTriStripsShape = (NiRTTI *)0x03188278;
const NiRTTI *	NiRTTI_bhkPackedNiTriStripsShape = (NiRTTI *)0x031882A0;
const NiRTTI *	NiRTTI_bhkRigidBodyT = (NiRTTI *)0x031882B8;
const NiRTTI *	NiRTTI_bhkBlendCollisionObject = (NiRTTI *)0x031882D0;
const NiRTTI *	NiRTTI_bhkAvoidBox = (NiRTTI *)0x031882F0;
const NiRTTI *	NiRTTI_bhkLimitedHingeConstraint = (NiRTTI *)0x03188308;
const NiRTTI *	NiRTTI_bhkMalleableConstraint = (NiRTTI *)0x03188320;
const NiRTTI *	NiRTTI_bhkConstraint = (NiRTTI *)0x03188338;
const NiRTTI *	NiRTTI_bhkPrismaticConstraint = (NiRTTI *)0x03188350;
const NiRTTI *	NiRTTI_bhkAction = (NiRTTI *)0x03188368;
const NiRTTI *	NiRTTI_bhkUnaryAction = (NiRTTI *)0x03188380;
const NiRTTI *	NiRTTI_bhkTriSampledHeightFieldBvTreeShape = (NiRTTI *)0x03188398;
const NiRTTI *	NiRTTI_bhkCachingShapePhantom = (NiRTTI *)0x03189008;
const NiRTTI *	NiRTTI_bhkRagdollTemplateData = (NiRTTI *)0x03189030;
const NiRTTI *	NiRTTI_bhkRagdollTemplate = (NiRTTI *)0x03189040;
const NiRTTI *	NiRTTI_bhkSPCollisionObject = (NiRTTI *)0x03189050;
const NiRTTI *	NiRTTI_bhkMouseSpringAction = (NiRTTI *)0x03189068;
const NiRTTI *	NiRTTI_bhkHingeConstraint = (NiRTTI *)0x03189080;
const NiRTTI *	NiRTTI_bhkCompressedMeshShape = (NiRTTI *)0x031890F8;
const NiRTTI *	NiRTTI_bhkCompressedMeshShapeData = (NiRTTI *)0x03189108;
const NiRTTI *	NiRTTI_bhkConvexSweepShape = (NiRTTI *)0x03189120;
const NiRTTI *	NiRTTI_bhkConvexTransformShape = (NiRTTI *)0x03189138;
const NiRTTI *	NiRTTI_bhkConvexTranslateShape = (NiRTTI *)0x03189150;
const NiRTTI *	NiRTTI_bhkConvexVerticesShape = (NiRTTI *)0x03189168;
const NiRTTI *	NiRTTI_bhkCylinderShape = (NiRTTI *)0x03189180;
const NiRTTI *	NiRTTI_bhkMultiSphereShape = (NiRTTI *)0x03189198;
const NiRTTI *	NiRTTI_bhkPlaneShape = (NiRTTI *)0x031891B0;
const NiRTTI *	NiRTTI_bhkTriangleShape = (NiRTTI *)0x031891C8;
const NiRTTI *	NiRTTI_bhkMoppBvTreeShape = (NiRTTI *)0x031891E0;
const NiRTTI *	NiRTTI_bhkTransformShape = (NiRTTI *)0x031891F8;
const NiRTTI *	NiRTTI_bhkListShape = (NiRTTI *)0x03189210;
const NiRTTI *	NiRTTI_bhkBallAndSocketConstraint = (NiRTTI *)0x03189228;
const NiRTTI *	NiRTTI_bhkBallSocketConstraintChain = (NiRTTI *)0x03189240;
const NiRTTI *	NiRTTI_bhkGroupConstraint = (NiRTTI *)0x03189258;
const NiRTTI *	NiRTTI_bhkHingeLimitsConstraint = (NiRTTI *)0x03189270;
const NiRTTI *	NiRTTI_bhkFixedConstraint = (NiRTTI *)0x03189288;
const NiRTTI *	NiRTTI_bhkRagdollConstraint = (NiRTTI *)0x031892A0;
const NiRTTI *	NiRTTI_bhkRagdollLimitsConstraint = (NiRTTI *)0x031892B8;
const NiRTTI *	NiRTTI_bhkStiffSpringConstraint = (NiRTTI *)0x031892D0;
const NiRTTI *	NiRTTI_bhkWheelConstraint = (NiRTTI *)0x031892E8;
const NiRTTI *	NiRTTI_bhkBreakableConstraint = (NiRTTI *)0x03189300;
const NiRTTI *	NiRTTI_bhkAngularDashpotAction = (NiRTTI *)0x03189318;
const NiRTTI *	NiRTTI_bhkDashpotAction = (NiRTTI *)0x03189330;
const NiRTTI *	NiRTTI_bhkLiquidAction = (NiRTTI *)0x03189348;
const NiRTTI *	NiRTTI_bhkMotorAction = (NiRTTI *)0x03189368;
const NiRTTI *	NiRTTI_bhkOrientHingedBodyAction = (NiRTTI *)0x03189380;
const NiRTTI *	NiRTTI_bhkSpringAction = (NiRTTI *)0x03189398;
const NiRTTI *	NiRTTI_bhkBlendController = (NiRTTI *)0x031893A8;
const NiRTTI *	NiRTTI_bhkExtraData = (NiRTTI *)0x031893B8;
const NiRTTI *	NiRTTI_bhkPoseArray = (NiRTTI *)0x031893C8;
const NiRTTI *	NiRTTI_bhkGenericConstraint = (NiRTTI *)0x031893E8;
const NiRTTI *	NiRTTI_bhkCharControllerShape = (NiRTTI *)0x031893F8;
const NiRTTI *	NiRTTI_bhkCollisionBox = (NiRTTI *)0x03189410;
const NiRTTI *	NiRTTI_bhkShapeCollection = (NiRTTI *)0x03189428;
const NiRTTI *	NiRTTI_bhkPositionConstraintMotor = (NiRTTI *)0x03189490;
const NiRTTI *	NiRTTI_bhkVelocityConstraintMotor = (NiRTTI *)0x031894A0;
const NiRTTI *	NiRTTI_bhkSpringDamperConstraintMotor = (NiRTTI *)0x031894B0;
const NiRTTI *	NiRTTI_bhkCharacterProxy = (NiRTTI *)0x0318A2B8;
const NiRTTI *	NiRTTI_bhkCharacterRigidBody = (NiRTTI *)0x0318A2D0;
const NiRTTI *	NiRTTI_bhkHeightFieldShape = (NiRTTI *)0x0318B5D8;
const NiRTTI *	NiRTTI_bhkConstraintChain = (NiRTTI *)0x0318B5F0;
const NiRTTI *	NiRTTI_bhkBinaryAction = (NiRTTI *)0x0318B608;
const NiRTTI *	NiRTTI_bhkPointToPathConstraint = (NiRTTI *)0x0318B640;
const NiRTTI *	NiRTTI_DebugTextExtraData = (NiRTTI *)0x0318CE70;
const NiRTTI *	NiRTTI_BSFadeNode = (NiRTTI *)0x03422F38;
const NiRTTI *	NiRTTI_BSShaderProperty = (NiRTTI *)0x03422F68;
const NiRTTI *	NiRTTI_BSLeafAnimNode = (NiRTTI *)0x03422F78;
const NiRTTI *	NiRTTI_BSTreeNode = (NiRTTI *)0x03422F88;
const NiRTTI *	NiRTTI_ShadowSceneNode = (NiRTTI *)0x03423520;
const NiRTTI *	NiRTTI_BSLightingShaderProperty = (NiRTTI *)0x03423E20;
const NiRTTI *	NiRTTI_BSGrassShaderProperty = (NiRTTI *)0x03423E58;
const NiRTTI *	NiRTTI_BSShaderAccumulator = (NiRTTI *)0x03424080;
const NiRTTI *	NiRTTI_BSEffectShaderProperty = (NiRTTI *)0x03424340;
const NiRTTI *	NiRTTI_BSWaterShaderProperty = (NiRTTI *)0x03485190;
const NiRTTI *	NiRTTI_BSBloodSplatterShaderProperty = (NiRTTI *)0x034851A0;
const NiRTTI *	NiRTTI_BSParticleShaderProperty = (NiRTTI *)0x03485758;
const NiRTTI *	NiRTTI_BSTextureSet = (NiRTTI *)0x03485B88;
const NiRTTI *	NiRTTI_BSShaderTextureSet = (NiRTTI *)0x03485B98;
const NiRTTI *	NiRTTI_BSSkyShaderProperty = (NiRTTI *)0x03485EA8;
const NiRTTI *	NiRTTI_BSFadeNodeCuller = (NiRTTI *)0x034D5F70;
const NiRTTI *	NiRTTI_BSDistantTreeShaderProperty = (NiRTTI *)0x034D5FA0;
const NiRTTI *	NiRTTI_BSCubeMapCamera = (NiRTTI *)0x034D6180;
const NiRTTI *	NiRTTI_BSFogProperty = (NiRTTI *)0x034D6238;
const NiRTTI *	NiRTTI_BSClearZNode = (NiRTTI *)0x036F1748;
const NiRTTI *	NiRTTI_NiCollisionObject = (NiRTTI *)0x036F1A50;
const NiRTTI *	NiRTTI_BSOrderedNode = (NiRTTI *)0x036F1A60;
const NiRTTI *	NiRTTI_BSLines = (NiRTTI *)0x036F1A70;
const NiRTTI *	NiRTTI_BSDynamicLines = (NiRTTI *)0x036F1A80;
const NiRTTI *	NiRTTI_BSMultiIndexTriShape = (NiRTTI *)0x036F1AA0;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyFloatController = (NiRTTI *)0x036F1B40;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyUShortController = (NiRTTI *)0x036F1B58;
const NiRTTI *	NiRTTI_BSLightingShaderPropertyColorController = (NiRTTI *)0x036F1B70;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyFloatController = (NiRTTI *)0x036F1BA8;
const NiRTTI *	NiRTTI_BSEffectShaderPropertyColorController = (NiRTTI *)0x036F1BC0;
const NiRTTI *	NiRTTI_BSNiAlphaPropertyTestRefController = (NiRTTI *)0x036F1BD0;
const NiRTTI *	NiRTTI_BSPSysSimpleColorModifier = (NiRTTI *)0x036F1BE0;
const NiRTTI *	NiRTTI_BSPSysLODModifier = (NiRTTI *)0x036F1BF0;
const NiRTTI *	NiRTTI_BSParabolicCullingProcess = (NiRTTI *)0x036F1EB8;
const NiRTTI *	NiRTTI_BSLODMultiIndexTriShape = (NiRTTI *)0x036F1EC8;
const NiRTTI *	NiRTTI_BSSubIndexLandTriShape = (NiRTTI *)0x036F1EE0;
